/*
 * @(#)OMGeneralization.java  1.0  4. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodel;

import java.beans.*;
import ch.hslu.cm.simulation.*;
/**
 * Simulates the structure and behavior of a generalization between two classes.
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 4. Februar 2004  Created.
 */
public class OMGeneralization extends AbstractRelationship {
    private PropertyChangeSupport changeSupport;
    
    /** Creates a new instance. */
    public OMGeneralization() {
        changeSupport = new PropertyChangeSupport(this);
    }
    
    public void addPropertyChangeListener(PropertyChangeListener l) {
        changeSupport.addPropertyChangeListener(l);
    }
    public void removePropertyChangeListener(PropertyChangeListener l) {
        changeSupport.removePropertyChangeListener(l);
    }
    
    public int getSimulatedConcept() {
        return ObjectModel.GENERALIZATION;
    }
    
    public OMGeneralization clone() {
        OMGeneralization that = (OMGeneralization) super.clone();
        that.changeSupport = new PropertyChangeSupport(that);
        return that;
    }
    
    
    public boolean canConnect(SimulatedElement start, SimulatedElement end) {
        if (start.getSimulatedConcept() == ObjectModel.CLASS
        && end.getSimulatedConcept() == ObjectModel.CLASS) {
            OMClass subclass = (OMClass) start;
            OMClass superclass = (OMClass) end;
            
            return (subclass.getGeneralization() == null || subclass.getGeneralization() == this)
            && ! subclass.isAssignableFrom(superclass);
        }
        return false;
    }
    public boolean canConnect(SimulatedElement start) {
        int concept = start.getSimulatedConcept();
        if (concept == ObjectModel.CLASS) {
            OMClass subclass = (OMClass) start;
            return subclass.getGeneralization() == null;
        }
        return false;
    }
    public OMClass getSuperclass() {
        return (OMClass) getEnd();
    }
    public OMClass getSubclass() {
        return (OMClass) getStart();
    }
}
